#include <iostream>
#include <bits/stdc++.h>
#include <chrono>

using namespace std;

struct Graph{
	vector<vector<int>> adj;
	vector<bool> vis;
	vector<int> dub;
	int n;
};

void inic(Graph &g, int n){
	g.adj.resize(n);
	g.dub.resize(n,0);
	g.vis.resize(n,false);
	g.n = n;
}

void addEdge(Graph &g, int u, int v){
	g.adj[u].push_back(v);
	g.adj[v].push_back(u);
}

void cl(Graph &g)
{
	g.vis.resize(g.n, false);
	g.dub.resize(g.n,0);
}

int mx(vector<int> niz, int n) {
	int max = INT_MIN;
	for(int i = 0; i < n; i++)
		if(niz[i] > max) max = niz[i];
	return max;
}

int bfs(Graph g, int x, set<int> s) {
    queue<int> q;
    s.erase(x);
    g.vis[x] = true;
    q.push(x);
    g.dub[x] = 0;
    while(!q.empty() && !s.empty())
    {
        int a = q.front();
        q.pop();
        s.erase(a);
        if(s.empty()) break;
        for (int i = 0; i < g.adj[a].size(); i++) {
            if (!g.vis[g.adj[a][i]]) {
                g.vis[g.adj[a][i]] = true;
                q.push(g.adj[a][i]);
                g.dub[g.adj[a][i]] = g.dub[a]+1;
                s.erase(g.adj[a][i]);
            }
        }
    }
	return mx(g.dub, g.n);
}

void solve(){
	Graph g;
	int n;
	scanf("%d", &n);
	inic(g, n);
	int niz[n];
	for(int i = 0; i < n; i++) {
		scanf("%d", &niz[i]);
		niz[i]--;
	}
		
	for(int i = 0; i < n - 1; i++){
		int u, v;
		scanf("%d %d", &u, &v);
		addEdge(g, u-1, v-1);
	}
	int q;
	scanf("%d", &q);
	for(int i = 0; i < q; i++) {
		int y;
		scanf("%d", &y);
		if(y == 1){
			int a, b, pom;
			scanf("%d %d", &a, &b);
			a--; b--;
			pom = niz[a];
			niz[a] = niz[b];
			niz[b] = pom;
		}
		else {
			int l, r, x;
			scanf("%d %d %d", &l, &r, &x);
			l--; r--; x--;
			set<int> s;
			for(int i = l; i <= r; i++)
				s.insert(niz[i]);
			cout << bfs(g, x, s) << "\n";
		}
	}
}

int main(int argc, char** argv) {
	ios_base::sync_with_stdio(false); cin.tie(NULL);
	//auto start = std::chrono::high_resolution_clock::now();
	//freopen("input.txt", "r", stdin);
	solve();
	//auto finish = std::chrono::high_resolution_clock::now();
	//std::chrono::duration<double> elapsed = finish - start;
	//std::cout << "\nElapsed time: " << elapsed.count() << " s\n";
	return 0;
}